/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  switch.c
//  Read-out of the switches
//
//  Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#include "main.h"



// Initialization of the switches
// the input register is low when the switch is pressed
void init_switches(void)
{
	// set pins as inputs
	clear_bit(S1_PDIR, S1_BIT);
	clear_bit(S2_PDIR, S2_BIT);
	clear_bit(S3_PDIR, S3_BIT);
	clear_bit(S4_PDIR, S4_BIT);
	
	// disable pullups
	clear_bit(S1_RES, S1_BIT);
	clear_bit(S2_RES, S2_BIT);
	clear_bit(S3_RES, S3_BIT);
	clear_bit(S4_RES, S4_BIT);
	
	// set I/O function
	clear_bit(S1_PSEL, S1_BIT);
	clear_bit(S2_PSEL, S2_BIT);
	clear_bit(S3_PSEL, S3_BIT);
	clear_bit(S4_PSEL, S4_BIT);
}



// Check if a key has been pressed.
// Each pressed key is reported only once
unsigned int get_key_press( unsigned int key_mask )
{
	_DINT();					// read and clear atomic, interrupts off!
	key_mask &= key_press;		// read key(s)
	key_press ^= key_mask;		// clear key(s)
	_EINT();					// enable interrupts
	
	return key_mask;
}



// Check if a key has been pressed long enough such that the
// key repeat functionality kicks in. After a small setup delay
// the key is reported being pressed in subsequent calls
// to this function. This simulates the user repeatedly
// pressing and releasing the key.
unsigned int get_key_rpt( unsigned int key_mask )
{
	_DINT();					// read and clear atomic, interrupts off!
	
	key_mask &= key_rpt;		// read key(s)	
	
	key_rpt = key_rpt ^ key_mask;	// delete key(s)
 
	
	_EINT();					// enable interrupts
	
	return key_mask;
}



// Check if a key is pressed short.
unsigned int get_key_short( unsigned int key_mask )
{
	return get_key_press( ~key_state & key_mask );
}
